import {connect} from 'react-redux';
import {push} from 'react-router-redux';
import {postClientEdit, postClientCreate, editFieldChange} from '../../../middlewares/edit';
import {ClientFormParams as Component} from './ClientFormParams';

const mapStateToProps = ({
    edit: {scopes = {}, ttl, ttlRefreshable = false, requiresApproval = false, clientId = ''} = {},
    common: {permissionsById = {}},
    settings: {tld = 'ru'} = {}
} = {}) => ({scopes, permissionsById, ttl, ttlRefreshable, requiresApproval, clientId, tld});
const mapDispatchToProps = {editFieldChange, postClientEdit, postClientCreate, pushHistory: push};

export const ClientFormParams = connect(mapStateToProps, mapDispatchToProps)(Component);
