const times = {
    year: {
        one: i18n('frontend.time.time.year.one'),
        some: i18n('frontend.time.time.year.some'),
        many: i18n('frontend.time.time.year.many')
    },
    day: {
        one: i18n('frontend.time.time.day.one'),
        some: i18n('frontend.time.time.day.some'),
        many: i18n('frontend.time.time.day.many')
    },
    hour: {
        one: i18n('frontend.time.time.hour.one'),
        some: i18n('frontend.time.time.hour.some'),
        many: i18n('frontend.time.time.hour.many')
    },
    minute: {
        one: i18n('frontend.time.time.minute.one'),
        some: i18n('frontend.time.time.minute.some'),
        many: i18n('frontend.time.time.minute.many')
    },
    second: {
        one: i18n('frontend.time.time.second.one'),
        some: i18n('frontend.time.time.second.some'),
        many: i18n('frontend.time.time.second.many')
    }
};

const getPluralForm = (amount) => {
    const num = Math.round(amount);
    const numStr = String(num);
    const lastDigit = numStr[numStr.length - 1];
    const some = ['2', '3', '4'];
    const many = ['0', '5', '6', '7', '8', '9'];

    if (num > 10 && num < 20) {
        return 'many';
    } else if (some.includes(lastDigit)) {
        return 'some';
    } else if (many.includes(lastDigit)) {
        return 'many';
    }

    return 'one';
};

export const formatTokenLifeSpan = (ttl) => {
    let amount, message;
    const YEAR = 31536000;
    const DAY = 86400;
    const HOUR = 3600;
    const MINUTE = 60;

    if (ttl === null || ttl === 0) {
        return i18n('frontend.app.app.ttl.infinite');
    } else if (ttl >= YEAR) {
        amount = ttl / YEAR;
        message = times.year[getPluralForm(amount)];
    } else if (ttl >= DAY) {
        amount = ttl / DAY;
        message = times.day[getPluralForm(amount)];
    } else if (ttl >= HOUR) {
        amount = ttl / HOUR;
        message = times.hour[getPluralForm(amount)];
    } else if (ttl >= MINUTE) {
        amount = ttl / MINUTE;
        message = times.minute[getPluralForm(amount)];
    } else {
        amount = ttl;
        message = times.second[getPluralForm(ttl)];
    }

    return `${amount} ${message}`;
};
