import React from 'react';
import {Button} from 'pcomponents/Button';
import {cn} from '@bem-react/classname';
import './ClientFormPreview.styl';

const b = cn('ClientFormPreview');

const toBase64 = (file) =>
    new Promise((resolve, reject) => {
        const reader = new FileReader();

        reader.onload = () => resolve(reader.result);
        reader.onerror = (error) => reject(error);
        reader.readAsDataURL(file);
    });

export class ClientFormPreview extends React.Component {
    state = {permissions: []};
    constructor(props) {
        super(props);

        this.state = {
            permissions: this.getPermissions(),
            isDefaultAvatar: props.avatarPath.includes('/0/0-0/'),
            iconUrl: props.iconUrl
        };
    }
    componentDidUpdate(props) {
        if (this.props.scopes !== props.scopes) {
            this.updatePermissions();
        }
        if (this.props.iconUrl !== props.iconUrl) {
            this.setIconUrl(this.props.iconUrl);
        }
        if (this.props.icon !== props.icon) {
            this.props.icon
                ? toBase64(this.props.icon).then((base64) => this.setIconUrl(base64))
                : this.setIconUrl(null);
        }
    }

    setIconUrl = (iconUrl) => this.setState({iconUrl});
    updatePermissions = () => this.setState({permissions: this.getPermissions()});

    getPermissions = () => {
        const {scopes = {}} = this.props;

        return Object.keys(scopes).reduce((acc, section) => {
            acc.push(...Object.keys(scopes[section]));

            return acc;
        }, []);
    };

    mapPermissions = (permissionId) => {
        const {permissionsById = {}} = this.props;

        return (
            permissionsById[permissionId] && (
                <div className={b('permission')} key={permissionId}>
                    {permissionsById[permissionId].title}
                </div>
            )
        );
    };

    render() {
        const {title = '', name = '', avatarPath = '', hasPlus = false, lang = 'ru'} = this.props;
        const {isDefaultAvatar = false, iconUrl = null, permissions = []} = this.state;

        return (
            <div className={b()}>
                <div className={b('wrap')}>
                    <div className={b('avatarBlock')}>
                        {iconUrl && <div className={b('avatarClient')} style={{backgroundImage: `url(${iconUrl})`}} />}
                        <div
                            className={b('avatarUser', {hasPlus})}
                            style={{backgroundImage: isDefaultAvatar ? undefined : `url(${avatarPath})`}}
                        >
                            {isDefaultAvatar && (
                                <svg
                                    width='76'
                                    height='76'
                                    viewBox='0 0 76 76'
                                    fill='none'
                                    xmlns='http://www.w3.org/2000/svg'
                                >
                                    <path
                                        //eslint-disable-next-line max-len
                                        d='M60.964 68.2789C70.1004 61.339 76 50.3584 76 38C76 17.0132 58.9868 0 38 0C17.0132 0 0 17.0132 0 38C0 47.6671 3.60982 56.4911 9.55503 63.1975C16.1462 61.7 26.8198 59.0622 29.9026 57.9047C30.877 51.119 29.9026 44.5679 29.9026 44.5679C29.9026 44.5679 28.8626 46.2804 26.4358 44.0541C24.1824 41.6566 22.1023 30.455 26.4358 33.0238C26.4358 33.0238 26.0892 26.2381 26.4358 22.1666C26.195 21.0084 25.5939 20.5388 24.996 20.0789C25.4484 19.6266 26.3532 19.4524 27.2579 19.5652C27.2579 19.5652 28.9838 17.1735 32.243 14.6593C33.6532 13.5714 36.1667 13.4775 38.1151 13.5714C46.2579 13.9638 48.6233 11.8626 48.6233 11.8626C48.6233 11.8626 49.877 16.2857 47.4099 17.1677C47.4099 17.1677 50.4436 17.5943 53.0437 16.7381C53.0437 16.7381 52.1389 19.4524 49.1433 19.5652C49.1433 19.5652 52.6 20.4318 53.9484 20.0789C53.7121 21.4821 52.1389 22.1666 52.1389 22.1666C52.1389 22.1666 53.496 22.619 53.9484 23.9762C52.5913 23.9762 52.1389 24.4286 51.6865 24.8809V28.0745C51.6865 28.0745 52.1548 28.1699 52.6078 28.0745C52.4886 29.0998 52.2501 29.5051 51.4147 30.3109C51.4147 31.198 51.2875 32.9483 50.8767 33.6078C50.8767 33.6078 52.6101 32.0665 53.1301 33.6078C53.7953 35.5793 50.7034 46.1091 48.6233 43.8829C48.6233 43.8829 45.6765 55.8704 39.4363 56.0417C34.3893 56.0417 33.2555 53.9086 33.0586 53.0537C34.0437 60.619 40.377 60.619 46.2579 59.2619C46.2579 59.2619 51.8704 61.9508 60.964 68.2789Z'
                                        fill='#DFE4EE'
                                    />
                                    <path
                                        //eslint-disable-next-line max-len
                                        d='M38.0313 76C37.9978 76 37.9642 76 37.9307 75.9999C37.9538 76 37.9769 76 38 76C38.0104 76 38.0209 76 38.0313 76Z'
                                        fill='#DFE4EE'
                                    />
                                    <path
                                        fillRule='evenodd'
                                        clipRule='evenodd'
                                        //eslint-disable-next-line max-len
                                        d='M38 72C56.7777 72 72 56.7777 72 38C72 19.2223 56.7777 4 38 4C19.2223 4 4 19.2223 4 38C4 56.7777 19.2223 72 38 72ZM38 76C58.9868 76 76 58.9868 76 38C76 17.0132 58.9868 0 38 0C17.0132 0 0 17.0132 0 38C0 58.9868 17.0132 76 38 76Z'
                                        fill='#DFE4EE'
                                    />
                                </svg>
                            )}
                            <svg
                                className={b('ya')}
                                width='24'
                                height='24'
                                viewBox='0 0 48 48'
                                fill='none'
                                xmlns='http://www.w3.org/2000/svg'
                            >
                                <circle cx='24' cy='24' r='24' fill='#fc3f1d' />
                                <path
                                    d={
                                        lang === 'en'
                                            ? //eslint-disable-next-line max-len
                                              'M24.7,26.7c1.5,3.2,1.9,4.3,1.9,8.2V40h-5.2v-8.6L11.6,10H17L24.7,26.7z M31.1,10l-6.4,14.5H30L36.4,10H31.1z'
                                            : //eslint-disable-next-line max-len
                                              'M27.2,13.6H25c-4.1,0-6.2,2.1-6.2,5.1c0,3.4,1.5,5,4.5,7.1l2.5,1.7l-7.2,10.8h-5.4l6.5-9.6c-3.7-2.7-5.8-5.3-5.8-9.6c0-5.5,3.8-9.2,11.1-9.2h7.2v28.5h-5V13.6z'
                                    }
                                    fill='#fff'
                                />
                            </svg>
                        </div>
                    </div>
                    <div className={b('title')}>{i18n('Authorize.title')}</div>
                    <div className={b('changeAccount')}>{i18n('Authorize.account.link')}</div>
                    <div className={b('button')}>
                        <Button view='oauth-authorize' size='l' width='max'>
                            {i18n('Authorize.button.allow').replace('%name', name)}
                        </Button>
                    </div>
                    <div className={b('scopes')}>
                        <div className={b('scopesTitle')}>
                            {i18n('Authorize.client.start')} <b className={b('scopesName')}>«{title}»</b>{' '}
                            {i18n('Authorize.client.end')}
                        </div>
                        <div className={b('permissions')}>{permissions.map(this.mapPermissions)}</div>
                    </div>
                </div>
                <div className={b('hint')}>{i18n('Authorize.preview.hint')}</div>
            </div>
        );
    }
}
