import {connect} from 'react-redux';
import {push as pushHistory} from 'react-router-redux';
import {withRouter} from 'react-router-dom';
import {clientsUpdateClient} from '../../../actions/clients';
import {editSetStateById} from '../../../middlewares/edit';
import {fetchClientsState, postDeleteClient, postClientPasswordReset} from '../../../middlewares/clients';
import {ClientInfoPage as Component} from './ClientInfoPage';

const mapStateToProps = (
    {
        settings: {tld} = {},
        uatraits: {isMobile, isTouch} = {},
        edit: {clientId} = {},
        clients: {clientsMap = {}} = {}
    } = {},
    {match: {params: {clientId: clientIdUrl = ''} = {}} = {}} = {}
) => ({clientId, tld, isMobile, isTouch, clientIdUrl, clientsMap, client: clientsMap[clientIdUrl] || {}});
const mapDispatchToProps = {
    editSetStateById,
    pushHistory,
    fetchClientsState,
    postDeleteClient,
    postClientPasswordReset,
    clientsUpdateClient
};

export const ClientInfoPage = withRouter(connect(mapStateToProps, mapDispatchToProps)(Component));
