import React from 'react';
import {cn} from '@bem-react/classname';
import {ClientItemCard} from '../../common/ClientItemCard';
import {UsefullInfoBlock} from '../../common/UsefullInfoBlock';
import {ROUTES} from '../../../const';
import {metric} from '../../../metric';

import './ClientListPage.styl';

const b = cn('ClientListPage');

export class ClientListPage extends React.Component {
    componentDidMount() {
        this.props.fetchClientsState();
    }
    onItemClick = ({currentTarget: {dataset: {clientId = ''} = {}} = {}} = {}) =>
        this.props.pushHistory(ROUTES.INFO.replace(':clientId', clientId));
    onCreateClick = () => {
        metric.goal('lk_my_app_new_clientID_click');
        this.props.pushHistory(ROUTES.FORM_CREATE);
    };
    render() {
        const {idList = [], clientsMap = {}} = this.props;

        return (
            <div className={b()}>
                <div className={b('title')}>{i18n('ClientList.page.title')}</div>
                <div className={b('content')}>
                    <div className={b('list')}>
                        {idList.map((clientId) => {
                            const item = clientsMap[clientId];

                            if (!item) {
                                return null;
                            }

                            const {iconUrl, title, description, createTime} = item;

                            return (
                                <ClientItemCard
                                    key={clientId}
                                    iconUrl={iconUrl}
                                    title={title}
                                    description={description}
                                    createTime={createTime}
                                    clientId={clientId}
                                    onClick={this.onItemClick}
                                />
                            );
                        })}
                        <ClientItemCard
                            view='create'
                            title={i18n('ClientList.buttons.create')}
                            onClick={this.onCreateClick}
                        />
                    </div>
                    <div className={b('info')}>
                        <UsefullInfoBlock />
                    </div>
                </div>
            </div>
        );
    }
}
