import {createStore, applyMiddleware, compose} from 'redux';
import {routerMiddleware} from 'connected-react-router';
import thunkMiddleware from 'redux-thunk';
import rootReducer from './reducers/';
import {devTools} from '../../devTools';

export default (initialState, history) =>
    createStore(
        rootReducer(history),
        initialState,
        compose(applyMiddleware(thunkMiddleware, routerMiddleware(history)), devTools)
    );
