export const FORM_FIELDS = {
    HOMEPAGE: 'homepage',
    TITLE: 'title',
    ICON: 'icon',
    ICON_ID: 'iconId',
    ICON_URL: 'iconUrl',
    DESCRIPTION: 'description',
    CONTACT: 'contact',
    PLATFORMS: 'platforms',
    IS_YANDEX: 'isYandex',
    WEB_CALLBACK_URLS: 'webCallbackUrls',
    IOS_APPSTORE_URL: 'iosAppstoreUrl',
    IOS_APP_ID: 'iosAppIds',
    IOS_DOMAINS: 'iosDomains',
    ANDROID_PACKAGE_NAMES: 'androidPackageNames',
    ANDROID_APPSTORE_URL: 'androidAppstoreUrl',
    ANDROID_FINGERPRINTS: 'androidFingerprints',
    ANDROID_SCHEMES: 'androidSchemes',
    TURBOAPP_URL: 'turboappUrl',
    SCOPES: 'scopes'
};

export const FORM_ERROR_FIELDS = {
    [FORM_FIELDS.TITLE]: 'title',
    [FORM_FIELDS.DESCRIPTION]: 'description',
    [FORM_FIELDS.WEB_CALLBACK_URLS]: 'redirect_uri',
    [FORM_FIELDS.IOS_APP_ID]: 'ios_app_id',
    [FORM_FIELDS.IOS_APPSTORE_URL]: 'ios_appstore_url',
    [FORM_FIELDS.ANDROID_APPSTORE_URL]: 'android_appstore_url',
    [FORM_FIELDS.ANDROID_FINGERPRINTS]: 'android_cert_fingerprints',
    [FORM_FIELDS.ANDROID_PACKAGE_NAMES]: 'android_package_name',
    [FORM_FIELDS.TURBOAPP_URL]: 'turboapp_base_url',
    [FORM_FIELDS.ICON]: 'icon',
    [FORM_FIELDS.SCOPES]: 'scopes',
    [FORM_FIELDS.HOMEPAGE]: 'homepage',
    [FORM_FIELDS.PLATFORMS]: 'platforms',
    [FORM_FIELDS.CONTACT]: 'contact_email'
};

export const FORM_ERRORS = {
    title: {
        ['missing']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['too_long']: i18n('frontend.fields.field.title.error.toolong')
    },
    description: {
        ['too_long']: i18n('frontend.fields.field.description.error.toolong'),
        ['missing']: i18n('frontend.fields.field.description.error.missing')
    },
    homepage: {
        ['invalid']: i18n('frontend.fields.field.url.error.invalid'),
        ['scheme_forbidden']: i18n('frontend.fields.field.callback.error.scheme_forbidden'),
        ['too_long']: i18n('frontend.fields.field._common_.error.url_too_long'),
        ['not_absolute']: i18n('frontend.fields.field.url.error.invalid'),
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['scheme_missing']: i18n('frontend.fields.field.url.error.invalid')
    },
    ['redirect_uri']: {
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['missing']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['invalid']: i18n('frontend.fields.field.url.error.invalid'),
        ['too_long']: i18n('frontend.fields.field._common_.error.url_too_long'),
        ['scheme_missing']: i18n('frontend.fields.field.url.error.invalid'),
        ['scheme_forbidden']: i18n('frontend.fields.field.callback.error.scheme_forbidden'),
        ['not_absolute']: i18n('frontend.fields.field.url.error.invalid')
    },
    icon: {
        ['bad_format']: i18n('frontend.fields.field.icon.error.badformat'),
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue')
    },
    ['icon_file']: {
        ['invalid_format']: i18n('frontend.fields.field.icon.error.badformat'),
        ['too_large']: i18n('frontend.fields.field.icon.error.toolarge')
    },
    ['ios_app_id']: {
        ['too_many']: i18n('frontend.authorize.authorize.errors.too_many.ios'),
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['missing']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['invalid']: i18n('frontend.fields.field._common_.error.invalid')
    },
    ['ios_appstore_url']: {
        ['invalid']: i18n('frontend.fields.field.url.error.invalid'),
        ['scheme_forbidden']: i18n('frontend.fields.field.callback.error.scheme_forbidden'),
        ['too_long']: i18n('frontend.fields.field._common_.error.url_too_long'),
        ['not_absolute']: i18n('frontend.fields.field.url.error.invalid'),
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['scheme_missing']: i18n('frontend.fields.field.url.error.invalid')
    },
    ['android_appstore_url']: {
        ['invalid']: i18n('frontend.fields.field.url.error.invalid'),
        ['scheme_forbidden']: i18n('frontend.fields.field.callback.error.scheme_forbidden'),
        ['too_long']: i18n('frontend.fields.field._common_.error.url_too_long'),
        ['not_absolute']: i18n('frontend.fields.field.url.error.invalid'),
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['scheme_missing']: i18n('frontend.fields.field.url.error.invalid')
    },
    ['android_package_name']: {
        ['too_many']: i18n('frontend.authorize.authorize.errors.too_many.android'),
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['missing']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['invalid']: i18n('frontend.fields.field._common_.error.invalid')
    },
    ['android_cert_fingerprints']: {
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['invalid']: i18n('frontend.fields.field._common_.error.invalid'),
        ['missing']: i18n('frontend.fields.field._common_.error.missingvalue')
    },
    scopes: {
        ['missing']: i18n('frontend.fields.field.scopes.error.missingvalue')
    },
    form: {
        ['internal']: i18n('frontend.authorize.authorize.errors.try_later')
    },
    platforms: {
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue')
    },
    ['turboapp_base_url']: {
        ['required']: i18n('frontend.fields.field._common_.error.missingvalue'),
        ['scheme_missing']: i18n('frontend.fields.field.url.error.invalid'),
        ['scheme_forbidden']: i18n('frontend.fields.field.callback.error.scheme_forbidden'),
        ['not_absolute']: i18n('frontend.fields.field.url.error.invalid')
    },
    ['contact_email']: {
        ['invalid']: i18n('frontend.fields.field._common_.error.invalid'),
        ['too_long']: i18n('frontend.fields.field._common_.error.invalid'),
        ['not_absolute']: i18n('frontend.fields.field._common_.error.invalid'),
        ['scheme_missing']: i18n('frontend.fields.field._common_.error.invalid')
    }
};

export const FORM_PLATFORMS = {
    WEB: 'web',
    IOS: 'ios',
    ANDROID: 'android',
    TURBOAPP: 'turboapp'
};

export const FILE_FIELD_VIEW_TYPES = {
    NAME: 'name',
    PICTURE: 'picture'
};

export const ROUTES = {
    FORM_EDIT: '/client/edit/:clientId',
    FORM_CREATE: '/client/new',
    FORM_CREATE_WITH_TAG: '/client/new/:tag',
    LIST: '/',
    INFO: '/client/:clientId'
};

export const LINKS = {
    FORM_CREATE_AGREEMENT: 'https://yandex.%tld/legal/authid_api/'
};
