import * as clientsActions from '../actions/clients';
import {makeRequest} from './util';

export const fetchClientsState = () => (dispatch, getState) => {
    const {common: {csrf = ''} = {}} = getState();

    const formData = new FormData();

    formData.set('csrf', csrf);

    return makeRequest(dispatch, '/client/api/state/clients', formData).then((response) => {
        dispatch(clientsActions.clientsUpdateState(response));
    });
};

export const postDeleteClient = (clientId) => (dispatch, getState) => {
    const {common: {csrf = ''} = {}} = getState();

    const formData = new FormData();

    formData.set('csrf', csrf);
    formData.set('clientId', clientId);

    return makeRequest(dispatch, '/client/api/delete', formData);
};

export const postClientPasswordReset = (clientId) => (dispatch, getState) => {
    const {common: {csrf = ''} = {}} = getState();

    const formData = new FormData();

    formData.set('csrf', csrf);
    formData.set('clientId', clientId);

    return makeRequest(dispatch, '/client/api/password/reset', formData);
};
