import * as commonActions from '../actions/common';

const createRequest = (url, body, method) =>
    new Request(url, {
        body,
        method,
        mode: 'same-origin',
        credentials: 'same-origin',
        redirect: 'follow'
    });

const validateResponse = async (res) =>
    res.ok && (res.headers.get('content-type') || '').includes('application/json')
        ? await res.json()
        : {status: 'error', ...([404, 500].includes(res.status) ? {errors: ['form.internal']} : {})};

export const makeRequest = (dispatch, url, data) => {
    dispatch(commonActions.setLoading(true));
    return fetch(createRequest(url, data, 'POST'))
        .then(validateResponse)
        .then((response) => {
            dispatch(commonActions.setLoading(false));

            return response;
        });
};
