import * as actions from '../actions/clients';

const reducers = {
    [actions.clientsSetState.type]: (state, payload) => ({...state, ...payload}),
    [actions.clientsUpdateState.type]: (state, {idList, clientsMap}) => ({
        ...state,
        idList,
        clientsMap: {...state.clientsMap, ...clientsMap}
    }),
    [actions.clientsUpdateClient.type]: (state, {clientId, client}) => ({
        ...state,
        clientsMap: {...state.clientsMap, [clientId]: {...state.clientsMap[clientId], ...client}}
    }),
    [actions.clientsAddClient.type]: (state, {clientId, client}) => ({
        ...state,
        idList: [...state.idList, clientId],
        clientsMap: {...state.clientsMap, [clientId]: client}
    }),

    default: (state) => state
};

export const clientsReducer = (state = {}, {type, payload} = {}) =>
    (reducers[type] || reducers.default)(state, payload);
