import * as actions from '../actions/edit';

const reducers = {
    [actions.editFieldChange.type]: (state, {field, value}) => ({...state, [field]: value}),
    [actions.editPermissionToggle.type]: (state, {section, permissionId}) => {
        const newState = {...state, scopes: state.scopes ? {...state.scopes} : {}};

        if (!state.scopes || !state.scopes[section]) {
            newState.scopes[section] = {[permissionId]: true};
        } else {
            newState.scopes[section] = {...newState.scopes[section]};
            if (!state.scopes[section][permissionId]) {
                newState.scopes[section][permissionId] = true;
            } else {
                delete newState.scopes[section][permissionId];
                if (!Object.keys(newState.scopes[section]).length) {
                    delete newState.scopes[section];
                }
            }
        }

        return newState;
    },
    [actions.editSetValidateResult.type]: (state, {status, ...validateResult}) => ({
        ...state,
        validateResult: {...state.validateResult, errors: [], ...validateResult},
        validateErrors: validateResult.errors
            ? validateResult.errors.reduce((acc, errorKey) => {
                  const [field, indexOrKey, key] = errorKey.split('.');

                  if (acc[field] && key) {
                      acc[field][indexOrKey] = key;
                  } else {
                      acc[field] = key ? {[indexOrKey]: key} : indexOrKey;
                  }

                  return acc;
              }, {})
            : {}
    }),
    [actions.editClearForm.type]: () => ({}),
    [actions.editSetState.type]: (state, payload) => ({...state, ...payload}),

    default: (state) => state
};

export const editReducer = (state = {}, {type, payload} = {}) => (reducers[type] || reducers.default)(state, payload);
