import React from 'react';
import {Provider} from 'react-redux';
import {renderToString} from 'react-dom/server';
import {ConnectedRouter} from 'connected-react-router';
import createMemoryHistory from 'history/createMemoryHistory';
import configureStore from './configureStore';
import {App} from './app';
import {ROUTES} from './const';

export default (state, location = ROUTES.LIST) => {
    const history = createMemoryHistory({initialEntries: [location]});
    const store = configureStore(state, history);

    return renderToString(
        <Provider store={store}>
            <ConnectedRouter history={history}>
                <App />
            </ConnectedRouter>
        </Provider>
    );
};
