import Api from '../api';

export const ENTER_CODE_STATUS = 'ENTER_CODE_STATUS';
export const REQUEST_PERMISSION_STATUS = 'REQUEST_PERMISSION_STATUS';
export const SUCCESS_STATUS = 'SUCCESS_STATUS';
export const ERROR_STATUS = 'ERROR_STATUS';

export const SET_DEVICE_CODE = '[DEVICE_PAGE] SET_DEVICE_CODE';
export const CHANGE_STATUS = '[DEVICE_PAGE] CHANGE_STATUS';
export const START_FETCHING = '[DEVICE_PAGE] START_FETCHING';
export const FETCH_AUTHORIZATION_DATA = '[DEVICE_PAGE] FETCH_AUTHORIZATION_DATA';
export const FAIL_AUTHORIZATION_DATA = '[DEVICE_PAGE] FAIL_AUTHORIZATION_DATA';


export function setDeviceCode(deviceCode) {
    return {
        type: SET_DEVICE_CODE,
        deviceCode
    };
}

export function changeStatus(status) {
    return {
        type: CHANGE_STATUS,
        status
    };
}

export function startFetching() {
    return {
        type: START_FETCHING
    };
}

export function fetchAuthorizationData(data) {
    return {
        type: FETCH_AUTHORIZATION_DATA,
        data
    };
}

export function failAuthorizationData(data) {
    return {
        type: FAIL_AUTHORIZATION_DATA,
        data
    };
}

export function sendCode(code) {
    return (dispatch, getState) => {
        const {
            csrf,
            clientId
        } = getState().devicePage;

        dispatch(startFetching());

        Api.deviceAuthorizeSubmit(csrf, code, clientId)
            .then((response) => {
                dispatch(setDeviceCode(code));
                dispatch(fetchAuthorizationData(response));
            })
            .catch((error) => {
                dispatch(failAuthorizationData(error));
            });
    };
}

export function allowClientRequest(code) {
    return (dispatch, getState) => {
        const {
            csrf,
            clientId
        } = getState().devicePage;

        dispatch(startFetching());

        Api.deviceAuthorizeCommit(csrf, code, clientId)
            .then(() => {
                dispatch(setDeviceCode(''));
                dispatch(changeStatus(SUCCESS_STATUS));
            })
            .catch((error) => {
                dispatch(setDeviceCode(''));
                dispatch(changeStatus(ERROR_STATUS));
                dispatch(failAuthorizationData(error));
            });
    };
}
