const Api = {
    _createRequest(url, body, method) {
        return new Request(url, {
            body,
            method,
            mode: 'same-origin',
            credentials: 'same-origin',
            redirect: 'follow'
        });
    },

    _validateResponse(res) {
        let errors;

        if (res.ok) {
            const contentType = res.headers.get('content-type') || '';

            if (contentType.includes('application/json')) {
                return res.json().then((json) => {
                    if (json.status === 'error') {
                        return Promise.reject(json);
                    }

                    return Promise.resolve(json);
                });
            }
        }

        if (res.status === 500) {
            errors = ['form.internal'];
        }

        return Promise.reject({
            status: 'error',
            errors
        });
    },

    deviceAuthorizeSubmit(csrf, code, clientId) {
        const formData = new FormData();

        formData.append('code', code);
        formData.append('csrf', csrf);

        if (clientId) {
            formData.append('client_id', clientId);
        }

        return fetch(this._createRequest('/device', formData, 'POST'))
            .then(this._validateResponse);
    },

    deviceAuthorizeCommit(csrf, code, clientId) {
        const formData = new FormData();

        formData.append('code', code);
        formData.append('csrf', csrf);

        if (clientId) {
            formData.append('client_id', clientId);
        }

        return fetch(this._createRequest('/device/allow', formData, 'POST'))
            .then(this._validateResponse);
    }
};

export default Api;
