import React from 'react';
import ReactDOM from 'react-dom';
import {Provider} from 'react-redux';
import configureStore from './configureStore';
import DevicePage from './components/DevicePage.jsx';
import {changeStatus, ENTER_CODE_STATUS} from './actions';

$(function() {
    const root = document.getElementById('root');
    const initialState = JSON.parse(root.getAttribute('data-redux-state'));
    const store = configureStore(initialState);

    // Hack
    root.parentNode.style.padding = 0;

    store.dispatch(changeStatus(ENTER_CODE_STATUS));

    ReactDOM.render(
        <Provider store={store}>
            <DevicePage/>
        </Provider>,
        root
    );
});
