import React from 'react';
import PropTypes from 'prop-types';

export default function ClientScopesList({scopes}) {
    return (
        <div className='clientScopesList'>
            {
                scopes.map((scope) => (
                    <ul className='clientScopesList-scope' key={scope.id}>
                        <li>{scope.title}</li>
                    </ul>
                ))
            }
        </div>
    );
};

ClientScopesList.propTypes = {
    scopes: PropTypes.array.isRequired
};

