import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';

import EnterCodeScreen from './EnterCodeScreen.jsx';
import RequestPermissionScreen from './RequestPermissionScreen.jsx';
import SuccessScreen from './SuccessScreen.jsx';
import ErrorScreen from './ErrorScreen.jsx';
import SelectedUser from './SelectedUser.jsx';
import Footer from './Footer.jsx';

import './DevicePage.styl';

import {
    ENTER_CODE_STATUS,
    SUCCESS_STATUS,
    ERROR_STATUS,
    changeStatus
} from '../actions';

class DevicePage extends PureComponent {
    static mapStateToProps(state) {
        const {
            devicePage: {status, currentUser, origin, redirectUrl},
            settings: {language, passportHost, tld}
        } = state;

        const deviceName = state.devicePage.deviceName ? state.devicePage.deviceName : '';

        return {
            status,
            origin,
            currentUser,
            deviceName,
            language,
            passportHost,
            redirectUrl,
            tld
        };
    }

    constructor(props) {
        super(props);

        this.goToStartScreen = this.goToStartScreen.bind(this);
        this.goToResultPage = this.goToResultPage.bind(this);
    }

    componentWillUpdate(nextProps) {
        if (this.props.status !== nextProps.status) {
            window.scrollTo(0, 0);
        }
    }

    goToStartScreen() {
        this.props.dispatch(changeStatus(ENTER_CODE_STATUS));
    }

    goToResultPage() {
        const {
            passportHost,
            redirectUrl
        } = this.props;

        window.location.href = redirectUrl || `https://${passportHost}/profile`;
    }

    render() {
        const {tld, language, currentUser, status, deviceName, origin} = this.props;
        const langs = ['en', 'fr', 'tr', 'fi', 'id'];
        const logoLang = langs.includes(language) ? 'en' : 'ru';
        const isShowUserBlock = status === ENTER_CODE_STATUS;

        return (
            <div className={classnames('device-page', {
                'device-page__kinopoisk': origin === 'kinopoisk'
            })}>
                <div className='device-page__background'/>
                <div className={classnames('device-page__content', {
                    user_block_showed: isShowUserBlock
                })}>
                    <div className={`logo logo__${logoLang}`}/>

                    <EnterCodeScreen/>
                    <RequestPermissionScreen/>
                    <SuccessScreen
                        isActive={status === SUCCESS_STATUS}
                        deviceName={deviceName}
                        goToResultPage={this.goToResultPage}/>
                    <ErrorScreen
                        isActive={status === ERROR_STATUS}
                        goToStartScreen={this.goToStartScreen}
                        goToResultPage={this.goToResultPage}/>

                    {isShowUserBlock &&
                        <SelectedUser user={currentUser}/>
                    }
                </div>

                <div className='device-page__footer'>
                    <Footer tld={tld} page='device-page'/>
                </div>
            </div>
        );
    }
}

DevicePage.propTypes = {
    status: PropTypes.string.isRequired,
    passportHost: PropTypes.string.isRequired,
    language: PropTypes.string.isRequired,
    redirectUrl: PropTypes.string,
    tld: PropTypes.string.isRequired,
    deviceName: PropTypes.string.isRequired,
    currentUser: PropTypes.object.isRequired
};

export default connect(DevicePage.mapStateToProps)(DevicePage);
