import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import Button from 'lego-on-react/src/components/button/button.react';

export default class ErrorScreen extends PureComponent {
    render() {
        const {goToStartScreen, goToResultPage, isActive} = this.props;

        return (
            <div className={classnames('error-screen', {
                active: isActive
            })}>
                <div className='device-code-error-img'/>

                <h1 className='screen-title'>{i18n('frontend.device.fail_title')}</h1>
                <div className='screen-description'>{i18n('frontend.device.fail_description')}</div>

                <div className='btn-group'>
                    <div className='start-screen__btn'>
                        <Button
                            theme='action'
                            size='l'
                            width='max'
                            type='button'
                            onClick={goToStartScreen}>
                            {i18n('frontend.device.try_send_code_again')}
                        </Button>
                    </div>

                    <div className='main-page__btn'>
                        <Button
                            theme='normal'
                            size='l'
                            width='max'
                            type='button'
                            onClick={goToResultPage}>
                            {i18n('frontend.device.cancel_code_send')}
                        </Button>
                    </div>
                </div>

            </div>
        );
    }
}

ErrorScreen.propTypes = {
    isActive: PropTypes.bool.isRequired,
    goToStartScreen: PropTypes.func.isRequired,
    goToResultPage: PropTypes.func.isRequired
};
