import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {getDocumentationTld} from '../../utils';

import Link from 'lego-on-react/src/components/link/link.react';

export default class Footer extends PureComponent {
    render() {
        const {tld, page} = this.props;
        const currentYear = new Date().getFullYear();
        const documentationTld = getDocumentationTld(tld);
        const additionalClass = page ? `footer-${page}` : '';
        const documentationLink = `http://yandex.${documentationTld}/dev/oauth/`;

        return (
            <div className={classnames('footer', additionalClass)}>
                <span className='footer-item'>
                    <Link theme='normal' url={documentationLink} target='_blank'>
                        {i18n('frontend.index.index.nav.doc')}
                    </Link>
                </span>
                <span className='footer-item footer-item__rights'>
                    {`© ${tld === 'ru' ? '2001-' : ''}${currentYear}, `}
                    <Link theme='normal' url={`//yandex.${tld}`}>
                        {i18n('frontend.common.common.yandexltd')}
                    </Link>
                </span>
            </div>
        );
    }
}

Footer.propTypes = {
    tld: PropTypes.string.isRequired,
    page: PropTypes.string.isRequired
};
