import React from 'react';
import PropTypes from 'prop-types';

export default function SelectedUser({user}) {
    const name = user.displayName ? user.displayName : user.login;
    const avatarStyle = {backgroundImage: `url("${user.avatarPath}")`};

    return (
        <div className='account'>
            <div className='account-block'>
                <div className='account-avatar' style={avatarStyle}/>
                <span className='account-name'>
                    <span>{name}</span>
                </span>
                <a className='account-auth-link' href={user.changeAccountLink}>
                    {i18n('frontend.common.common.account.change')}
                </a>
            </div>
        </div>
    );
};

SelectedUser.propTypes = {
    user: PropTypes.shape({
        displayName: PropTypes.string,
        login: PropTypes.string.isRequired,
        avatarPath: PropTypes.string.isRequired,
        changeAccountLink: PropTypes.string.isRequired
    }).isRequired
};
