import React, {PureComponent} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import Spin from 'lego-on-react/src/components/spin/spin.react';

class Spinner extends PureComponent {
    static mapStateToProps(state) {
        const {isFetching} = state.devicePage;

        return {isFetching};
    }

    render() {
        const {isFetching} = this.props;

        if (!isFetching) {
            return null;
        }

        return (
            <div className='fetching-block'>
                <Spin progress={true} size='l'/>
            </div>
        );
    }
}

Spinner.propTypes = {
    isFetching: PropTypes.bool.isRequired
};

export default connect(Spinner.mapStateToProps)(Spinner);
