import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import Button from 'lego-on-react/src/components/button/button.react';

export default class SuccessScreen extends PureComponent {
    constructor(props) {
        super(props);
    }

    render() {
        const {deviceName, goToResultPage, isActive} = this.props;
        const title = deviceName && deviceName !== '' ?
            i18n('frontend.device.client_approved_title_with_device_name', deviceName) :
            i18n('frontend.device.client_approved_title');

        return (
            <div className={classnames('success-screen', {
                active: isActive
            })}>
                <div className='device-code-success-img'/>

                <h1 className='screen-title'>{i18n('frontend.device.done_title')}</h1>
                <div className='screen-description'>{title}</div>

                <div className='main-page__btn'>
                    <Button
                        theme='action'
                        size='l'
                        width='max'
                        type='button'
                        onClick={goToResultPage}>
                        {i18n('frontend.device.done_link')}
                    </Button>
                </div>
            </div>
        );
    }

}

SuccessScreen.propTypes = {
    isActive: PropTypes.bool.isRequired,
    deviceName: PropTypes.string.isRequired,
    goToResultPage: PropTypes.func.isRequired
};
