import {
    SET_DEVICE_CODE,
    CHANGE_STATUS,
    START_FETCHING,
    FETCH_AUTHORIZATION_DATA,
    FAIL_AUTHORIZATION_DATA,
    REQUEST_PERMISSION_STATUS
} from '../actions';
import _ from 'lodash';

export function rootReducer(state, action) {
    switch (action.type) {
        case SET_DEVICE_CODE: {
            const {deviceCode} = action;

            return Object.assign({}, state, {
                devicePage: Object.assign({}, state.devicePage, {
                    deviceCode
                })
            });
        }
        case CHANGE_STATUS: {
            const {status} = action;

            return Object.assign({}, state, {
               devicePage: Object.assign({}, state.devicePage, {
                   isFetching: false,
                   errors: [],
                   status
               })
            });
        }
        case START_FETCHING: {
            return Object.assign({}, state, {
                devicePage: Object.assign({}, state.devicePage, {
                    isFetching: true
                })
            });
        }
        case FETCH_AUTHORIZATION_DATA: {
            const payload = action.data;
            const requestedScopes = _.merge(payload.requested_scopes, payload.already_granted_scopes);
            const clientScopes = [];

            for (const scopeTitle in requestedScopes) {
                if (!requestedScopes.hasOwnProperty(scopeTitle)) {
                    continue;
                }

                const scopeList = requestedScopes[scopeTitle];

                const requestedScope = {title: scopeTitle, scopes: []};
                for (const scopeName in scopeList) {
                    if (!scopeList.hasOwnProperty(scopeName)) {
                        continue;
                    }

                    requestedScope.scopes.push({
                        id: scopeName,
                        title: scopeList[scopeName].title
                    });
                }

                clientScopes.push(requestedScope);
            }

            return Object.assign({}, state, {
                devicePage: Object.assign({}, state.devicePage, {
                    status: REQUEST_PERMISSION_STATUS,
                    isFetching: false,
                    errors: [],
                    deviceName: payload.device_name,
                    clientTitle: payload.client.title ? payload.client.title : '',
                    clientScopes
                })
            });
        }
        case FAIL_AUTHORIZATION_DATA: {
            const payload = action.data;

            return Object.assign({}, state, {
                devicePage: Object.assign({}, state.devicePage, {
                    isFetching: false,
                    errors: payload.errors
                })
            });
        }
        default: return state;
    }
}
