import React from 'react';
import {Provider} from 'react-redux';
import configureStore from './configureStore';
import {renderToString} from 'react-dom/server';
import DevicePage from './components/DevicePage.jsx';
import {changeStatus, ENTER_CODE_STATUS} from './actions';

export default function(state) {
    const store = configureStore(state);

    store.dispatch(changeStatus(ENTER_CODE_STATUS));

    return renderToString(
        <Provider store={store}>
            <DevicePage/>
        </Provider>
    );
};
