import Metrika from '../blocks/metrics/Metrika';

export default {
    initialized: false,
    headerMetrics: [],
    init: function (header, experiments) {
        const data = document.querySelector('body').dataset || {};
        const {metricsId} = data;

        if (metricsId) {
            if (header) {
                this.headerMetrics = [header];
            }
            Metrika.init(metricsId, experiments);
            this.initialized = true;
        }
    },

    send: function (params) {
        if (this.initialized) {
            setTimeout(() => {
                Metrika.count(this.headerMetrics.concat(params));
            }, 0);
        }
    },

    goal: function (target, params) {
        if (this.initialized) {
            Metrika.reachGoal(target, params);
        }
    }
};
