const MONTHS = {
    0: i18n('frontend.time.time.month.gen.0'),
    1: i18n('frontend.time.time.month.gen.1'),
    2: i18n('frontend.time.time.month.gen.2'),
    3: i18n('frontend.time.time.month.gen.3'),
    4: i18n('frontend.time.time.month.gen.4'),
    5: i18n('frontend.time.time.month.gen.5'),
    6: i18n('frontend.time.time.month.gen.6'),
    7: i18n('frontend.time.time.month.gen.7'),
    8: i18n('frontend.time.time.month.gen.8'),
    9: i18n('frontend.time.time.month.gen.9'),
    10: i18n('frontend.time.time.month.gen.10'),
    11: i18n('frontend.time.time.month.gen.11')
};

const getTimes = () => {
    return {
        year: {
            one: i18n('frontend.time.time.year.one'),
            some: i18n('frontend.time.time.year.some'),
            many: i18n('frontend.time.time.year.many')
        },
        day: {
            one: i18n('frontend.time.time.day.one'),
            some: i18n('frontend.time.time.day.some'),
            many: i18n('frontend.time.time.day.many')
        },
        hour: {
            one: i18n('frontend.time.time.hour.one'),
            some: i18n('frontend.time.time.hour.some'),
            many: i18n('frontend.time.time.hour.many')
        },
        minute: {
            one: i18n('frontend.time.time.minute.one'),
            some: i18n('frontend.time.time.minute.some'),
            many: i18n('frontend.time.time.minute.many')
        },
        second: {
            one: i18n('frontend.time.time.second.one'),
            some: i18n('frontend.time.time.second.some'),
            many: i18n('frontend.time.time.second.many')
        }
    };
};

const getPluralForm = (amount) => {
    const num = Math.round(amount);
    const numStr = String(num);
    const lastDigit = numStr[numStr.length - 1];
    const some = ['2', '3', '4'];
    const many = ['0', '5', '6', '7', '8', '9'];

    if (num >= 11 && num <= 19) {
        return 'many';
    } else if (some.includes(lastDigit)) {
        return 'some';
    } else if (many.includes(lastDigit)) {
        return 'many';
    }

    return 'one';
};

const formatTokenLife = (ttl, lang) => {
    const YEAR = 31536000;
    const DAY = 86400;
    const HOUR = 3600;
    const MINUTE = 60;
    const times = getTimes(lang);

    let amount, message;

    if (ttl === null || ttl === 0) {
        return i18n('frontend.app.app.ttl.infinite');
    } else if (ttl >= YEAR) {
        amount = ttl / YEAR;
        message = times.year[getPluralForm(amount)];
    } else if (ttl >= DAY) {
        amount = ttl / DAY;
        message = times.day[getPluralForm(amount)];
    } else if (ttl >= HOUR) {
        amount = ttl / HOUR;
        message = times.hour[getPluralForm(amount)];
    } else if (ttl >= MINUTE) {
        amount = ttl / MINUTE;
        message = times.minute[getPluralForm(amount)];
    } else {
        amount = ttl;
        message = times.second[getPluralForm(ttl)];
    }

    return `${amount} ${message}`;
};

const isTokenRefreshable = (scopes) => {
    if (!scopes) {
        return false;
    }

    return Object.values(scopes).every((scope) => scope.isTtlRefreshable || !scope.ttl || scope.ttl === 'INFINITE');
};

export const getTtlInfoString = ({scopes, ttl} = {}) => {
    const formatedToken = formatTokenLife(ttl);

    return isTokenRefreshable(scopes) && !(ttl === null || ttl === 0)
        ? `${i18n('frontend.app.app.ttl.at_least')} ${formatedToken}`
        : formatedToken;
};

export const dateToText = (date = {}) => {
    let {month, day, year} = '';

    month = MONTHS[date.getMonth()];
    day = date.getDate();
    year = date.getYear() + 1900;

    return `${day} ${month} ${year}`;
};

export const getDocumentationTld = (tld) => {
    if (tld === 'com.tr') {
        return 'com';
    } else if (tld === 'ua') {
        return 'ru';
    }

    return tld;
};
