// Page classes
const AbstractPage = require('./pages/AbstractPage');
const IndexPage = require('./pages/index/IndexPage');
const MyPage = require('./pages/client/my/MyPage');
const EditPage = require('./pages/client/edit/EditPage');
const ResetPasswordPage = require('./pages/client/ResetPasswordPage');
const DeletePage = require('./pages/client/DeletePage');
const RevokePage = require('./pages/client/RevokePage');
const InfoPage = require('./pages/client/info/InfoPage');
const VerificationCodePage = require('./pages/verificationCode/VerificationCodePage');
const ErrorPage = require('./pages/auth/error/ErrorPage');
const AccessPage = require('./pages/access/AccessPage');
const DevicePage = require('./pages/device/DevicePage');
const Error404Page = require('./pages/error/Error404Page.js');
const inherit = require('inherit');
const typedMapping = require('prouter/TypedMapping');

const Router = inherit(typedMapping, {
    __constructor: function () {
        this.__base(AbstractPage);
    }
});

module.exports = new Router()
    .map('/', IndexPage)

    // Clients created by me
    .map('/client/my', MyPage)

    // Both creating new and editing old apps are handled by single edit page
    .map(/^\/client\/(new|edit|validate)\/?([0-9a-f]{32})?$/, EditPage)

    // Resetting the client password
    .map(/^\/client\/password\/reset\/[0-9a-f]{32}$/, ResetPasswordPage)
    .map(/^\/client\/password\/reset\/undo\/[0-9a-f]{32}$/, ResetPasswordPage)

    // Deleting the client
    .map(/^\/client\/delete\/[0-9a-f]{32}$/, DeletePage)

    // Revoking the access
    .map(/^\/client\/revoke\/[0-9a-f]{32}$/, RevokePage)

    // All the other client urls are probably the info pages
    .map(/^\/client\/[0-9a-f]{32}(?:\/undosecret|\/secretundone)?$/, InfoPage)

    //Authorization-error
    .map(/^\/magic-link\/\S+\/finish\/?$/, ErrorPage)

    //Authorization-error
    .map('/auth/finish', ErrorPage)

    //Verification code
    .map('/verification_code', VerificationCodePage)

    // Legacy /list_tokens page (contains a single redirect)
    .map('/list_tokens', AccessPage)

    // Application passwords and tokens redirector
    .map('/access', AccessPage)

    // Device authorization by code
    .map(/^\/device(\/(allow|deny))?$/, DevicePage)

    // Not found — 404
    .default(Error404Page);
