const putils = require('putils');
const HTTPException = require('../../lib/exceptions/http/HTTPException');

module.exports.getImmediateExceptions = (controller) => {
    const unknownClientException = new HTTPException(
        400,
        putils.i18n(controller.getLang(), 'authorize.errors.client_id_unknown')
    );

    return {
        'client.not_found': unknownClientException,
        'client_id.too_long': unknownClientException,
        'client_id.too_short': unknownClientException,
        'redirect_uri.not_absolute': new HTTPException(
            400,
            putils.i18n(controller.getLang(), 'authorize.errors.redirect_uri.not_absolute')
        ),
        'redirect_uri.missing': new HTTPException(
            400,
            putils.i18n(controller.getLang(), 'authorize.errors.redirect_uri.missing')
        ),
        'redirect_uri.not_matched': new HTTPException(
            400,
            putils.i18n(controller.getLang(), 'authorize.errors.callback_url_mismatch')
        ),
        'redirect_uri.not_registered': new HTTPException(
            403,
            putils.i18n(controller.getLang(), 'authorize.errors.callback_url_missing')
        ),
        'redirect_uri.scheme_forbidden': new HTTPException(
            400,
            putils.i18n(controller.getLang(), 'authorize.errors.scheme_forbidden')
        ),
        'redirect_uri.scheme_missing': new HTTPException(
            400,
            putils.i18n(controller.getLang(), 'authorize.errors.scheme_missing')
        )
    };
};

module.exports.getRedirectErrors = (error, controller) => ({
    'response_type.invalid': {
        code: 'unsupported_response_type',
        description: 'authorize.errors.response_type.invalid'
    },
    'response_type.missing': {
        code: 'unsupported_response_type',
        description: 'authorize.errors.response_type.missing'
    },
    'client.blocked': {
        code: 'unauthorized_client',
        description: 'authorize.errors.blocked'
    },
    'client.approval_pending': {
        code: 'unauthorized_client',
        description: 'authorize.errors.approval_pending'
    },
    'client.approval_rejected': {
        code: 'unauthorized_client',
        description: 'authorize.errors.approval_rejected'
    },
    'access.denied': {
        code: 'unauthorized_client',
        description: 'authorize.errors.access_denied'
    },
    'request.not_found': {
        code: 'access_denied',
        description: 'authorize.errors.request.not_found',
        reload_page: true
    },
    'scopes.not_matched': {
        code: 'invalid_scope',
        description: 'authorize.errors.scopes_not_matched'
    },
    scopes_empty: {
        code: 'invalid_scope',
        description: 'authorize.errors.scopes_empty'
    },
    'requested_scopes.invalid': {
        code: 'invalid_scope',
        description: 'authorize.errors.scopes_invalid'
    },
    'device_id.invalid': {
        code: 'invalid_request',
        description: 'authorize.errors.device_id.invalid'
    },
    'device_id.too_short': {
        code: 'invalid_request',
        description: 'authorize.errors.device_id.too_short'
    },
    'device_id.too_long': {
        code: 'invalid_request',
        description: 'authorize.errors.device_id.too_long'
    },
    'device_name.too_short': {
        code: 'invalid_request',
        description: 'authorize.errors.device_name.too_short'
    },
    'device_name.too_long': {
        code: 'invalid_request',
        description: 'authorize.errors.device_name.too_long'
    },
    'state.too_long': {
        code: 'invalid_request',
        description: 'authorize.errors.state.too_long'
    },
    'code_challenge.too_long': {
        code: 'invalid_request',
        description: 'authorize.errors.code_challenge.too_long'
    },
    'code_challenge.too_short': {
        code: 'invalid_request',
        description: 'authorize.errors.code_challenge.too_short'
    },
    'code_challenge_method.invalid': {
        code: 'invalid_request',
        description: 'authorize.errors.code_challenge_method.invalid'
    },
    'login_hint.invalid': {
        code: 'invalid_request',
        description: 'authorize.errors.login_hint.invalid'
    },
    'redirect_uri.insecure': {
        code: 'invalid_request',
        description: 'authorize.errors.callback_url_insecure'
    },
    'login_hint.request_error': {
        code: 'temporarily_unavailable',
        description: 'authorize.errors.login_hint.request_error'
    },
    'sslsession.required': {
        code: 'access_denied',
        description: 'authorize.errors.access_denied',
        redirect: true,
        get redirect_uri() {
            const url = new URL(controller.getAuthSecureUrl().href);

            url.query = {
                retpath: controller.getUrl().href,
                origin: controller.getRequestParam('origin') || 'oauth'
            };

            return url.toString();
        }
    },
    'payment_auth_retpath.missing': {
        code: 'invalid_request',
        description: 'authorize.errors.internal'
    },
    'payment_auth_scheme.unknown': {
        code: 'invalid_request',
        description: 'authorize.errors.payment_auth_scheme.unknown'
    },
    'payment_auth.not_passed': {
        code: 'invalid_request',
        description: 'authorize.errors.denied'
    },
    'payment_auth.required': {
        code: 'access_denied',
        description: 'authorize.errors.access_denied',
        redirect: true,
        isNoErrorInQuery: true,
        get redirect_uri() {
            return new URL(error.getResponse().payment_auth_url).href;
        }
    }
});
