const Logger = require('plog');
const clusterMaster = require('cluster-master');
const cluster = require('cluster');
const config = require('./config/current');

try {
    const logSettings = Logger.configure();

    logSettings
        .minLevel(config.loglevel)
        .setFormatter(logSettings.getFormatterByName('production'))
        .setHandler(logSettings.getHandlerByName('buffering'));
} catch (e) {
    console.error('WARN: failed to set prod settings for clustermaster logger');
}

const logger = new Logger('none', 'clustermaster');

clusterMaster({
    exec: './app.js',
    repl: false,
    onMessage: function (msg) {
        logger.error().type('message').write('Message from ', this.uniqueID, this.pid, msg);
    }
});

cluster.on('exit', function (worker, code, signal) {
    logger
        .error()
        .type('worker.exited')
        .write('pid: %s, code: %s, signal: %s, age: %s', worker.process.pid, code, signal, worker.age);
});
