import json, io

loc = {}
with io.open('./loc/_locs.json', encoding='utf8') as _loc:
    _loc = json.load(_loc)
    for lang in _loc:
        loc[lang] = {}
        for keyset in _loc[lang]:
            for key in _loc[lang][keyset]:
                keyname = keyset + '.' + key
                loc[lang][keyname] = _loc[lang][keyset][key]

with io.open('./loc/locs.json', 'w', encoding='utf-8') as locFile:
    locFile.write(json.dumps(loc, ensure_ascii = False, sort_keys=True, indent=4))
