#!/bin/sh

mkdir -p ./loc/dynamic

HOST="https://tanker-api.yandex-team.ru"
FORMATS="loc json"
PROJECT="oauth"
LANGS="`node -e "console.log(require('./config/_common/loc').langs.join(' '))"`"
LANGS_JOINED="`node -e "console.log(require('./config/_common/loc').langs.join(','))"`"
KEYSETS="`node -e "console.log(require('./config/_common/loc').keysets.join(' '))"`"
REACT_PAGES_KEYSETS="frontend.app,frontend.access,frontend.authorize,frontend.common,frontend.fields,frontend.index,frontend.time,frontend.device,Authorize,ClientCommon,ClientForm,ClientInfo,ClientList"

STATUS=""
if [ "unapproved" = $1 ]
then
    STATUS="&status=unapproved"
fi

for LNG in ${LANGS}
do
    for FORMAT in ${FORMATS}
    do
        for KEYSET in ${KEYSETS}
        do
            wget --header="Authorization: OAuth $TANKER_TOKEN" --no-check-certificate -O "./loc/$KEYSET.$LNG.$FORMAT" "$HOST/keysets/$FORMAT/?project-id=$PROJECT&keyset-id=$KEYSET&language=$LNG&safe&flat-keyset=1$STATUS"
        done
    done

    wget --header="Authorization: OAuth $TANKER_TOKEN" --no-check-certificate --cache=off -O  "./loc/dynamic/tanker.dynamic.$LNG.js" "$HOST/tools/generate/i18n.xml?project-id=tanker&language=$LNG&keyset-id=dynamic&path=i18n&type=js&safe"
done

wget --header="Authorization: OAuth $TANKER_TOKEN" --no-check-certificate -O "loc/_locs.json" "$HOST/projects/export/json/?project-id=$PROJECT&keyset-id=$REACT_PAGES_KEYSETS&language=$LANGS_JOINED&flat-keyset=1&safe&all-forms=1&status=unapproved"
