#!/usr/bin/env bash

VERSION=$(cat ./debian/changelog | head -1 | sed 's/^.*(//' | sed 's/).*$//')

echo "RELEASE $VERSION"

echo "LOC UP"
make loc
arc add loc
arc commit -m "NOTASK: loc up" --no-verify

npm version "$VERSION"
arc add package.json package-lock.json

arc add debian
arc commit -m "NOTASK: Build $VERSION" --no-verify

exit 0
