const got = require('got');
const {format: urlFormat} = require('url');

module.exports = (opts = {}) => (req, res, next) => {
    const sessionid = req.cookies[opts.cookieName || 'Session_id'];
    const apiUrl = urlFormat({
        protocol: 'http',
        hostname: opts.api || 'blackbox.yandex.net',
        pathname: 'blackbox'
    });

    req.blackbox = {};

    if (!sessionid) {
        return next();
    }

    got(apiUrl, {
        json: true,
        query: {
            method: 'sessionid',
            sessionid,
            userip: req.headers['x-real-ip'],
            host: req.hostname,
            format: 'json'
        }
    })
        .then(res => {
            if (res.body) {
                const {
                    status: {
                        value: status
                    },
                    connection_id,
                    login
                } = res.body;

                req.blackbox = {
                    status,
                    connection_id,
                    login
                };

                return next();
            }

            return next(res.body.error);
        })
        .catch(error => {
            return next(error);
        });
};
