const got = require("got");
const { format: fmt } = require("util");
const DollarConfig = require("dollar-config");
const config = new DollarConfig(require("../configs/current/api.json"));
const ApiError = require("../handlers/error/ApiError.js");
const statbox = require("../handlers/log/helper.js");
const request = require("./request.js");

module.exports = (opts) => {
    const headers = {
        "Ya-Consumer-Client-Ip": opts.headers["x-real-ip"],
        "Ya-Client-Cookie": opts.headers.cookie || "",
        "Ya-Client-Host": opts.headers.host,
        "Ya-Client-User-Agent": opts.headers["user-agent"],
    };

    const body = {
        is_background: opts.is_background,
        retpath: opts.retpath,
        process_uuid: opts.process_uuid,
        container: opts.container,
    };

    const timeout = 3000;
    const retries = 0;

    let retriesOnTimeout = 1;

    function singleRequest(limit = 3) {
        return request(
            "/1/bundle/mda2/container/use/",
            body,
            headers,
            timeout,
            retries
        )
            .then((res) => {
                if (res.body && res.body.status === "ok") {
                    return res;
                }

                if (res.body && res.body.errors === "backend.blackbox_failed") {
                    if (limit) {
                        return singleRequest(limit - 1);
                    }

                    throw new ApiError(res.body.errors);
                }

                throw new ApiError(res.body.errors);
            })
            .catch((error) => {
                if (error.code === "ETIMEDOUT" && retriesOnTimeout--) {
                    console.error(
                        fmt("%j %s %j", new Date(), "retry_on_timeout", {
                            uuid: opts.process_uuid,
                            action: "use_container",
                            event: (opts.is_background && "pull") || "push",
                        })
                    );

                    return singleRequest(limit);
                }

                if (error instanceof ApiError) {
                    throw error;
                }

                throw new ApiError(error);
            });
    }

    return singleRequest();
};
