const got = require("got");
const DollarConfig = require("dollar-config");
const config = new DollarConfig(require("../configs/current/api.json"));
const ticketsFile =
    "/var/cache/yandex/passport-tvm-keyring/passport_sso_frontend.tickets";

const { promisify } = require("util");
const fs = require("fs");
const readFileAsync = promisify(fs.readFile);

module.exports = (url, body, headers = {}, timeout = 2000, retries = 2) => {
    return readFileAsync(ticketsFile, "utf8")
        .then((data) => JSON.parse(data))
        .then(
            (parsed) =>
                Object.entries(parsed.tickets).find(
                    (ticket) => ticket[1].alias === "passport-api"
                )[1].ticket
        )
        .then((serviceTicket) => {
            const requestHeaders = Object.assign(
                {
                    "X-Ya-Service-Ticket": serviceTicket,
                },
                headers
            );
            const req = Object.assign({}, config.get("defaults"), {
                headers: requestHeaders,
                body,
                timeout,
                retries,
            });

            return got(url, req);
        })
        .catch(console.error);
};
