const path = require("path");
const express = require("express");
const cookieParser = require("cookie-parser");
const expressUatraits = require("express-uatraits");
const logger = require("morgan");
const helmet = require("helmet");
const favicon = require("serve-favicon");
const dots = require("dot").process({ path: "./views" });

logger.token("remote-addr", function (req, res) {
    return req.headers["x-real-ip"];
});
logger.token("date", function () {
    const d = new Date();
    d.setUTCHours(d.getUTCHours() + 3);
    return d.toISOString();
});

// passport.yandex.ru
const pushRouter = require("./handlers/push/route.js");
const pullRouter = require("./handlers/pull/route.js");
const beaconRouter = require("./handlers/beacon/route.js");

// sso.kinopoisk.ru
const installRouter = require("./handlers/install/route.js");
const injectRouter = require("./handlers/inject/route.js");
const logRouter = require("./handlers/log/route.js");

// test.kinopoisk.ru
const foregroundRouter = require("./handlers/foreground/route.js");
const backgroundRouter = require("./handlers/background/route.js");
const xhrRouter = require("./handlers/xhr/route.js");
//
// autofill
const autofillRouter = require("./handlers/autofill/route.js");

const errorHandler = require("./handlers/error/route.js");

const app = express();
const ico = Buffer.alloc(1);

app.use(helmet.hidePoweredBy());
app.use(helmet.ieNoOpen());
app.use(helmet.noSniff());
app.use(
    ["/push", "/pull", "/install", "/inject", "/log", "/test"],
    helmet.noCache()
);
app.use(helmet.dnsPrefetchControl());
app.use(helmet.xssFilter());
app.use(logger("combined"));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(favicon(ico));
app.use(
    expressUatraits({
        browser: "/usr/share/uatraits/browser.xml",
        profiles: "/usr/share/uatraits/profiles.xml",
        uatraits: "/usr/lib/node_modules/uatraits",
    })
);
app.use("/st", express.static(path.join(__dirname, "public")));

app.use((req, res, next) => {
    req.dots = dots;
    return next();
});

app.use("/push", pushRouter);
app.use("/pull", pullRouter);
app.use("/beacon", beaconRouter);

app.use("/install", installRouter);
app.use("/inject", injectRouter);
app.use("/log", logRouter);

if (app.get("env") !== "production") {
    app.use("/test/foreground", foregroundRouter);
    app.use("/test/background", backgroundRouter);
    app.use("/test/xhr", xhrRouter);

    app.use("/", autofillRouter);
}

app.use(errorHandler);

module.exports = app;
