const {format: urlFormat} = require('url');
const express = require('express');
const uuid = require('uuid');
const DollarConfig = require('dollar-config');
const config = new DollarConfig(require('../../configs/current/main.json'));
const blackboxSessionId = require('../../api/blackboxSessionId.js');

const router = new express.Router();
const SOURCE_HOST = 'yandex.ru';
const TARGET_HOST = 'kinopoisk.ru';

router.use(blackboxSessionId({
    api: 'pass-test.yandex.ru',
    cookieName: 'ya_sess_id'
}));

router.get('/', (req, res, _) => {
    const passportHost = `${config.get('hosts.passport')}${SOURCE_HOST}`;
    const rootHost = `${config.get('hosts.leader')}${SOURCE_HOST}`;
    const ssoHost = `${config.get('hosts.sso')}${TARGET_HOST}`;
    const id = uuid.v4();
    const version = req.query.version || '2';
    const {
        status: authStatus,
        connection_id,
        login
    } = req.blackbox;
    const rootPushUrl = urlFormat({
        protocol: 'https',
        hostname: rootHost,
        pathname: 'push',
        query: {
            retpath: `https://${req.hostname}${req.originalUrl}`,
            uuid: id
        }
    });

    const rootAuthUrl = urlFormat({
        protocol: 'https',
        hostname: passportHost,
        pathname: 'auth',
        query: {
            retpath: rootPushUrl
        }
    });

    let csrfTokenName = 'yu';
    let csrfTokenValue = req.cookies.yandexuid;

    if (version === '2.1') {
        csrfTokenName = 'ci';
        csrfTokenValue = connection_id;
    }

    const rootLogoutUrl = urlFormat({
        protocol: 'https',
        hostname: passportHost,
        pathname: 'passport',
        query: {
            mode: 'logout',
            [csrfTokenName]: csrfTokenValue,
            retpath: rootPushUrl
        }
    });

    let message = 'Статус неизвестен';

    if (authStatus === 'VALID') {
        message = `АУТЕНТИФИЦИРОВАН как ${login}`;
    }

    if (authStatus === 'NEED_RESET') {
        message = `АУТЕНТИФИЦИРОВАН как ${login}, статус ${authStatus}`;
    }

    if (authStatus === 'NOAUTH') {
        message = 'ПОЛЬЗОВАТЕЛЬ НЕ АУТЕНТИФИЦИРОВАН';
    }

    return res
        .status(200)
        .send(req.dots.background({
            version,
            authStatus,
            login,
            message,
            rootAuthUrl,
            rootLogoutUrl,
            rootPushUrl,
            root: rootHost,
            sso: ssoHost,
            uuid: id
        }));
});

module.exports = router;
