const crypto = require('crypto');
const url = require('url');
const express = require('express');
const serialize = require('serialize-javascript');
const router = new express.Router();
const DollarConfig = require('dollar-config');
const config = new DollarConfig(require('../../configs/current/main.json'));
const ORIGINS = config.get('origins');
const getCSPHeader = require('../common/csp/index.js');

router.get('/', [
    getCSPHeader('origin'),
    (req, res, _) => {
        const origin = req.headers && req.headers.referer && url.parse(req.headers.referer).hostname.split('.').slice(-2).join('.');
        const retpath = (typeof ORIGINS[origin] !== 'undefined' ? req.headers.referer : null);
        const response = {
            scriptNonce: res.locals.scriptNonce,
            serialized: serialize({
                retpath
            })
        };

        res
            .status(200)
            .send(req.dots.beacon(response));
    }
]);

module.exports = router;
