const crypto = require('crypto');
const url = require('url');
const DollarConfig = require('dollar-config');
const config = new DollarConfig(require('../../../configs/current/main.json'));
const ORIGINS = config.get('origins');

module.exports = (hostFieldName) => (req, res, next) => {
    crypto.randomBytes(16, (err, buf) => {
        if (err) {
            throw err;
        }

        const originSource = hostFieldName === 'origin' && req.headers && req.headers.referer ||
            req.query && req.query.retpath ||
            req.body && req.body.retpath;
        const origin = originSource && url.parse(originSource).hostname.split('.').slice(-2).join('.');
        const NONE = '\'none\'';
        const SELF = '\'self\'';
        const NONCE = buf.toString('hex');
        const FRAME_ANCESTORS = ORIGINS[origin] || NONE;

        res.locals.scriptNonce = NONCE;
        res.append(
                'Content-Security-Policy',
                `default-src ${NONE}; frame-ancestors ${FRAME_ANCESTORS}; connect-src ${SELF}; script-src 'nonce-${NONCE}' ${SELF}; img-src ${SELF}`
        );

        return next();
    });
}
