const {format: fmt} = require('util');

module.exports = (err, req, res, _) => {
    const status = 400;
    const {
        uuid
    } = req.query;

    const {
        code,
        stack,
        message
    } = err;

    const data = {
        uuid,
        status,
        message
    };

    console.error(fmt(
        '%j %s %j %j',
        new Date(),
        code,
        data,
        stack
    ));

    return res
        .status(status)
        .send(req.dots.error(data));
};
