const url = require('url');
const express = require('express');
const uuid = require('uuid');
const DollarConfig = require('dollar-config');
const blackboxSessionId = require('../../api/blackboxSessionId.js');
const config = new DollarConfig(require('../../configs/current/main.json'));

const SOURCE_HOST = 'yandex.ru';
const TARGET_HOST = 'kinopoisk.ru';
const {format: urlFormat} = url;
const router = new express.Router();

router.use(blackboxSessionId({
    api: 'pass-test.yandex.ru',
    cookieName: 'ya_sess_id'
}));

router.get('/', (req, res, _) => {
    const passportHost = `${config.get('hosts.passport')}${SOURCE_HOST}`;
    const rootHost = `${config.get('hosts.leader')}${SOURCE_HOST}`;
    const ssoHost = `${config.get('hosts.sso')}${TARGET_HOST}`;
    const id = uuid.v4();
    const version = req.query.version || '2';
    const {
        status: authStatus,
        connection_id,
        login
    } = req.blackbox;
    const rootPushUrl = urlFormat({
        protocol: 'https',
        hostname: rootHost,
        pathname: 'push',
        query: {
            retpath: `https://${req.hostname}${req.originalUrl}`,
            uuid: id
        }
    });

    const rootAuthUrl = urlFormat({
        protocol: 'https',
        hostname: passportHost,
        pathname: 'auth',
        query: {
            retpath: rootPushUrl
        }
    });

    let csrfTokenName = 'yu';
    let csrfTokenValue = req.cookies.yandexuid;

    if (version === '2.1') {
        csrfTokenName = 'ci';
        csrfTokenValue = connection_id;
    }

    const rootLogoutUrl = urlFormat({
        protocol: 'https',
        hostname: passportHost,
        pathname: 'passport',
        query: {
            mode: 'logout',
            [csrfTokenName]: csrfTokenValue,
            retpath: rootPushUrl
        }
    });


    let message = 'Статус неизвестен';

    if (authStatus === 'VALID') {
        message = `АУТЕНТИФИЦИРОВАН как ${login}`;
    }

    if (authStatus === 'NOAUTH') {
        return res.redirect(rootAuthUrl);
    }

    if (authStatus !== 'VALID' && !req.query.sso_failed) {
        return res.redirect(rootPushUrl);
    }

    return res
        .status(200)
        .send(req.dots.background({ // Это не ошибка, шаблон один на back и front
            authStatus,
            login,
            message,
            version,
            rootAuthUrl,
            rootLogoutUrl,
            rootPushUrl,
            root: rootHost,
            sso: ssoHost,
            uuid: id
        }));
});

module.exports = router;
