const express = require('express');
const serialize = require('serialize-javascript');
const getUseMiddlewareGroup = require('../common/use/getUseMiddlewareGroup.js');

const router = new express.Router();

router.post('/',
    getUseMiddlewareGroup({
        isBackground: true
    }),
    (req, res, _) => {
        const {
            authStatus,
            cookieCheckValue,
            currentDomain,
            expiresBlockedTimeout,
            expiresTimeout,
            retpath,
            root,
            scriptNonce,
            uuid
        } = res.locals.context;

        const response = {
            scriptNonce,
            serialized: serialize({
                authStatus,
                cookieCheckValue,
                currentDomain,
                expiresBlockedTimeout,
                expiresTimeout,
                retpath,
                root,
                uuid
            })
        };

        res.status(200).send(req.dots.inject(response));
    }
);

module.exports = router;
