const {format: fmt} = require('util');
const {format: urlFormat} = require('url');
const express = require('express');
const serialize = require('serialize-javascript');
const getUseMiddlewareGroup = require('../common/use/getUseMiddlewareGroup.js');

const router = new express.Router();

router.post('/',
    getUseMiddlewareGroup({
        isBackground: false
    }),
    (req, res, _) => {
        const {
            authStatus,
            cookieCheckValue,
            currentDomain,
            expiresBlockedTimeout,
            expiresTimeout,
            retpath,
            retpathWithBlocked,
            retpathWithError,
            root,
            scriptNonce,
            uuid
        } = res.locals.context;

        const response = {
            scriptNonce,
            serialized: serialize({
                authStatus,
                cookieCheckValue,
                currentDomain,
                expiresBlockedTimeout,
                expiresTimeout,
                retpath,
                retpathWithBlocked,
                retpathWithError,
                root,
                uuid
            })
        };

        res.status(200).send(req.dots.install(response));
    }
);

router.get('/', (req, res, _) => {
    const {hostname} = req;
    const retpath = hostname.replace(/^([^.]+\.)(.*)$/g, '$2');

    console.error(fmt(
        '%j %s',
        new Date(),
        hostname
    ));

    return res.redirect(urlFormat({
        protocol: 'https',
        hostname: retpath,
        pathname: '/',
        query: {
            sso_failed: 'error'
        }
    }));
});


module.exports = router;
