const api = require('./api.js');
const getDomain = urlString => typeof urlString === 'string' && urlString.split('.').slice(-2).join('.');

const helper = function (opts) {
    const {
        status = 'ok',
        action,
        event,
        target,
        origin,
        uuid: process_uuid,
        result,
        cookies: {
            yandexuid
        },
        headers: {
            'x-real-ip': userIp,
            'user-agent': userAgent,
            referer,
            host
        }
    } = opts;

    api({
        action,
        event,
        status,
        target,
        origin,
        user_agent: userAgent,
        ip: userIp,
        host: getDomain(host),
        referer,
        process_uuid,
        result,
        yandexuid
    });
};

module.exports = helper;
