const express = require('express');
const router = new express.Router();
const schema = require('./schema.json');
const {Validator} = require('express-json-validator-middleware');
const api = require('./api.js');
const validator = new Validator({allErrors: true});
const {validate} = validator;
const DEBUG_ACTIONS = [
    'message_received',
    'clean_up'
];
const getDomain = urlString => typeof urlString === 'string' && urlString.split('.').slice(-2).join('.');

router.get('/',
    validate({query: schema}),
    (req, res, _) => {
        const {
            query: {
                status = 'ok',
                action,
                event,
                origin,
                target,
                result,
                message,
                uuid:  process_uuid
            },
            headers: {
                'x-real-ip': userIp,
                'user-agent': userAgent,
                host
            },
            cookies: {
                yandexuid
            }
        } = req;

        if (DEBUG_ACTIONS.indexOf(action) === -1) {
            api({
                action,
                event,
                status,
                target,
                origin,
                user_agent: userAgent,
                ip: userIp,
                host: getDomain(host),
                result,
                process_uuid,
                message,
                yandexuid
            });
        }

        return res.status('204').send('');
    });

module.exports = router;
