const express = require('express');
const serialize = require('serialize-javascript');

const router = new express.Router();
const getBuildMiddlewareGroup = require('../common/build/getBuildMiddlewareGroup.js');

router.get('/',
    getBuildMiddlewareGroup({
        isBackground: true,
        handle: 'inject',
        hostFieldName: 'origin'
    }),
    (req, res, _) => {
        const {
            authStatus,
            container,
            cookieCheckValue,
            currentDomain,
            expiresBlockedTimeout,
            expiresTimeout,
            host,
            origin,
            root,
            scriptNonce,
            uuid
        } = res.locals.context;

        const {
            BrowserName: browserName
        } = req.uatraits;

        const isITPBrowser = ['Safari', 'MobileSafari', 'Firefox'].indexOf(browserName) > -1;

        const response = {
            scriptNonce,
            container,
            serialized: serialize({
                host,
                authStatus,
                cookieCheckValue: isITPBrowser ? '0' : cookieCheckValue,
                currentDomain,
                expiresBlockedTimeout,
                expiresTimeout,
                origin,
                root,
                uuid
            })
        };

        res.status(200).send(req.dots.pull(response));
    }
);

module.exports = router;
