const express = require('express');
const serialize = require('serialize-javascript');

const router = new express.Router();
const getBuildMiddlewareGroup = require('../common/build/getBuildMiddlewareGroup.js');

router.get('/',
    getBuildMiddlewareGroup({
        isBackground: false,
        handle: 'install',
        hostFieldName: 'retpath'
    }),
    (req, res, _) => {
        const {
            scriptNonce,
            retpath,
            host,
            container
        } = res.locals.context;

        const response = {
            scriptNonce,
            container,
            serialized: serialize({
                host,
                retpath
            })
        };

        res
            .append('Referrer-Policy', 'origin')
            .status(200)
            .send(req.dots.push(response));
    }
);

module.exports = router;
