const url = require('url');
const express = require('express');
const uuid = require('uuid');
const router = new express.Router();
const {parse: urlParse, format: urlFormat} = url;
const SOURCE_HOST = 'yandex.ru';
const blackboxSessionId = require('../../api/blackboxSessionId.js');

router.use(blackboxSessionId({
    api: 'pass-test.yandex.ru',
    cookieName: 'ya_sess_id'
}));

router.get('/', (req, res, _) => {
    const {
        status: authStatus,
        login
    } = req.blackbox;

    let message = 'Статус неизвестен';

    if (authStatus === 'VALID') {
        message = `АУТЕНТИФИЦИРОВАН как ${login}`;
    }

    if (authStatus === 'NEED_RESET') {
        message = `АУТЕНТИФИЦИРОВАН как ${login}, статус ${authStatus}`;
    }

    if (authStatus === 'NOAUTH') {
        message = 'ПОЛЬЗОВАТЕЛЬ НЕ АУТЕНТИФИЦИРОВАН';
    }

    return res.status(200).json({status: 'OK', message});
});

module.exports = router;
