(function(window) {
    var SSO = window.SSO || (window.SSO = {});
    var BLOCKED = 'blocked';
    var FAIL = 'failed';
    var SYNC = 'synchronized';

    SSO.init = function(opts) {
        this.event = opts.event;
        this.authStatus = opts.authStatus;
        this.cookieCheckValue = opts.cookieCheckValue;
        this.currentDomain = opts.currentDomain;
        this.expiresBlockedTimeout = Number(opts.expiresBlockedTimeout);
        this.expiresTimeout = Number(opts.expiresTimeout);
        this.root = opts.root;
        this.uuid = opts.uuid;

        return this;
    };

    SSO.cookieCheck = function() {
        var status = this.getStatus();

        return this.saveStatus(status);
    };

    SSO.checkIfBlocked = function() {
        var sample = this.cookieCheckValue;
        var ys = document.cookie.replace(/(?:(?:^|.*;\s*)ys\s*\=\s*([^;]*).*$)|^.*$/, "$1");
        var chck = ys.replace(/(?:(?:^|.*#\s*)c_chck\s*\.\s*([^#]*).*$)|^.*$/, "$1");
        var isBlocked = sample !== chck;

        return isBlocked;
    };

    SSO._processStatus = function (ssoStatus) {
        var roots = ssoStatus.split('#');
        var result = {};
        var i = 0;
        var curr;

        if (!ssoStatus) {
            return result;
        }

        while (i < roots.length) {
            curr = roots[i].split(':');
            result[curr[0]] = curr[1];
            i++;
        }

        return result;
    };

    SSO._serializeStatus = function(statusObj) {
        var result = [];

        for (var domain in statusObj) {
            if (statusObj.hasOwnProperty(domain)) {
                result.push(domain + ':' + statusObj[domain]);
            }
        }

        return result.join('#');
    };

    SSO.getStatus = function() {
        var status = FAIL;
        var isBlocked = this.checkIfBlocked();

        if (isBlocked) {
            status = BLOCKED;
            return status;
        }

        if (this.authStatus) {
            status = SYNC;
            return status;
        };

        return status;

    };

    SSO.saveStatus = function(status) {
        var currentDomain = this.currentDomain;
        var expires = new Date(((status === BLOCKED && this.expiresBlockedTimeout) || this.expiresTimeout) + (new Date()).getTime());
        var ssoStatusValue = document.cookie.replace(/(?:(?:^|.*;\s*)sso_status\s*\=\s*([^;]*).*$)|^.*$/, "$1");
        var currentStatus = this._processStatus(ssoStatusValue);

        currentStatus[this.root] = status;
        document.cookie = 'sso_status=' + this._serializeStatus(currentStatus) + ';domain=.' + currentDomain + ';path=/;Expires=' + expires.toUTCString();
        this.finish(status);
    };
})(window);
