/* eslint-env node */

const paths = require('./tools/webpack.paths');

module.exports = (api) => {
    // api.cache(true);
    const web = api.caller(isWebTarget);
    const webpack = api.caller(isWebpack);
    const presets = [
        '@babel/preset-react',
        [
            '@babel/preset-env',
            {
                targets: !web ? {node: 'current'} : undefined,
                useBuiltIns: web ? 'entry' : undefined,
                corejs: web ? 'core-js@3' : false,
                modules: webpack ? false : 'commonjs'
            }
        ]
    ];
    const plugins = [
        '@babel/plugin-proposal-nullish-coalescing-operator',
        '@babel/plugin-syntax-dynamic-import',
        '@babel/plugin-proposal-class-properties',
        '@loadable/babel-plugin',
        [
            'module-resolver',
            {
                alias: paths.resolve.alias
            }
        ]
    ];

    return {
        presets,
        plugins
    };
};

function isWebTarget(caller) {
    return Boolean(caller && caller.target === 'clientside');
}

function isWebpack(caller) {
    return Boolean(caller && caller.name === 'babel-loader' && caller.target === 'clientside');
}
